/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 07-19-2007 FIX_FILTER_TO_GETN_OPTIONS									*
 * Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING	*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include "XFunctionEx.h" //<XFbase.h>
#include "fu_utils.h" /// Hong 8/18/06 REMOVE_TO_FU_UTILS
#include "iwbase.h"


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
static BOOL fuGetXFunction(TreeNode& tnFilter, TreeNode& tnXFunc)
{
	if( tnFilter.XFunction )
	{
		tnXFunc = tnFilter.XFunction;
		return TRUE;
	}
	return FALSE;
}

static BOOL fuGetXFunctionName(TreeNode& tnFilter, string& strName)
{
	TreeNode tnXFunc;
	if( fuGetXFunction(tnFilter, tnXFunc) )
	{
		if( tnXFunc.Name )
		{
			strName = tnXFunc.Name.strVal;
			return TRUE;
		}
	}
	return FALSE;
}
*/
///---END REMOVE_TO_FU_UTILS

class OC_REGISTERED IWXF : public IWBase
{

public:
	IWXF():IWBase() {m_iFilterType = FILTER_TYPE_XFUNC; } /// AW 08/03/06 MORE_ON_IW_IMPORT
	~IWXF() {}
protected:
	virtual int ImportFile(Layer& lyTarget, int nFile, string& strFileName, TreeNode& trFilter, TreeNode& tnInfo, int nImportMode) 
	{
		string strXFuncName;
		if( !fuGetXFunctionName(trFilter, strXFuncName) )
			return IMPERR_IMPORT_FUNC_ERR;
	
		XFunction xf;
		TreeNode trXF;
		//---- CPY 9/22/06 ANDREW_SAID_NEED_BEFORE_EXECUTE_FOR_DRAG_AND_DROP
		//bool bSkipHelpNodes = true;
		//bool bDialog = false;//true; // should be decided by trFilter, true not yet working, Yuri will need to find out why
		//// AW 09/27/06 OPEN_XF_DLG_IN_D&D
		//bool bDialog = true;
		bool bDialog  = fuGetXFSetting(trFilter);
		/// END OPEN_XF_DLG_IN_D
		//----
		bool bSkipHelpNodes = bDialog? false:true;
		if(!xf.Load(&trXF, strXFuncName, 0, true, bSkipHelpNodes, true))
			return IMPERR_IMPORT_FUNC_ERR;
	
		///---Sim 01-30-2007 CHANGE_FILTER_TO_XF_GUI
		//Tree trTheme;
		//xfuntion_tree_to_theme_tree(trXF, trTheme);
		//tree_copy_values_by_id(trFilter, trTheme);
		//xf.ApplyTheme(NULL, trTheme);
		Tree trJunk; // for memory of tree
		TreeNode trGetN;
		xf.GetGUI(trJunk, trGetN);
		if ( trGetN.trFilter )
		{
			xf.SetArg("trFilter", trFilter);
		}
		else
		{
			///---Sim 07-19-2007 FIX_FILTER_TO_GETN_OPTIONS
			//tree_copy_values_by_id(trFilter, trGetN);
			// trGetN has repeat ID on children, but trFilter don't. So make this change for avoid to failed to copy value
			if ( trGetN.options )
				tree_copy_values_by_id(trFilter, trGetN.options);
			///---END FIX_FILTER_TO_GETN_OPTIONS
			///---Sim 10-29-2008 v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
			update_getn_LT_variables(trGetN, strXFuncName, false);
			///---END v9.926b QA80-12484 IMPORT_EXCEL_FILTER_NEED_SPECIAL_HANDLING
			xf.SetGUI(trGetN);
		}
		///---END CHANGE_FILTER_TO_XF_GUI
		
		/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
		/*
		//---- CPY 7/18/06 MATRIXLAYER_SUPPORT_FOR_IMPORT
		//Worksheet wks = lyTarget;///pgTarget.Layers();
		Datasheet wks = lyTarget;
		//----
		DataRange dr;  
		/// AW 07/17/2006 IMPORT_MULTI_FILES_IN_ONE_WKS
		//dr.Add(wks,0);
		int nFirstTargetCol = 0;
		if ( ASCIMP_MODE_APPEND_COLS ==  nImportMode)
		{
			nFirstTargetCol = wks_find_empty_column(wks);
			if ( nFirstTargetCol < 0 )
			{
				Worksheet wksTemp = wks;       //// AW !!!!!! later need think about Matrixlayer and graphLayer
				nFirstTargetCol = wksTemp.GetNumCols();;
				wksTemp.AddCol();
			}
	
		}
		if(wks)
			dr.Add(wks,nFirstTargetCol);
		/// END IMPORT_MULTI_FILES_IN_ONE_WKS
		*/
		/// YuI 03/19/07 QA70-9503 MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
		//	SelfCreatingRange dr;
		DataRange dr;
		/// end MERGE_SELFCREATING_RANGE_INTO_COKPOLYRANGE
		GetDataRange(lyTarget, dr, nImportMode );
		/// END SUPPORT_MULTI_FILES_INXF
		
		/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
		//if( !xf.SetArg("fname", strFileName) )
		string strMultiFileNames;
		file_name_array_to_str(strMultiFileNames, saFileName);
		saFileName.SetSize(0);
		
		if( !xf.SetArg("fname", strMultiFileNames) )
		/// END SUPPORT_MULTI_FILES_INXF
			return FALSE;
		if( !xf.SetArg("orng", dr) )
			return FALSE;
		//xf.SetArg("trFilter", trFilter); ///---Sim 01-30-2007 CHANGE_FILTER_TO_THEME_FOR_XF
//		xf.SetArg("findex", nFile);
		///---Sim 02-01-2007 CLEAN_VAR_NAME
		if ( trGetN.finfo )
			xf.SetArg("finfo", tnInfo);
		if ( trGetN.trheader )
			xf.SetArg("trheader", tnInfo);
		///---END CLEAN_VAR_NAME
		//---- CPY 9/22/06 ANDREW_SAID_NEED_BEFORE_EXECUTE_FOR_DRAG_AND_DROP
//	int		ExecuteLabTalk(LPCSTR lpcszArgs, vector<string>* pvsVarValues, LPVOID lpRetData = NULL, int nRetDataXVT = XVT_INT, int* lpOCerr = NULL, DWORD dwCntrl = 0);
		//if(!xf.Evaluate() )
		DWORD dwCntrl = bDialog? LTXF_SHOW_DIALOG : 0;
		int nErr;
		if(xf.ExecuteLabTalk(NULL, NULL, NULL, 0, &nErr, dwCntrl) != 0)
		//----
			return IMPERR_IMPORT_FUNC_ERR;
		
		m_orng = dr; /// AW 07/31/06 MORE_ON_IW_FILTER
		return IMPERR_NONE;
	}
	/// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
	/// AW 08/03/06 MORE_ON_IW_IMPORT
	//virtual int GenerateImpInfo(string& strFileName, Layer& lyTarget, TreeNode& trImpIno) 
	//{
		///---Sim 08-02-2006 WHERE_GET_IMPORT_INFO_FROM_DATA_RANGE
		// should make impinfo here from DataRange, no in XF
		/*
		Worksheet ws;
		int r1, r2, c1, c2;
		DataRange dr;
		m_orng.GetRange(0, ws, r1, c1, r2, c2);
		dr.SetRange("Import", ws, r1, c1, r2, c2);
		TreeNode trRange = trImpInfo.AddNode("FileDataRange");
		dr.GetTree(trRange);
		*/
		///---END WHERE_GET_IMPORT_INFO_FROM_DATA_RANGE
	//	return 0;  // implemented in XF
	//}
	
	virtual void SetDataRange(Page&pgTarget, TreeNode& trImpInfo)
	{
	}
	/// END MORE_ON_IW_IMPORT
	
	// END ADD_DATA_RANGE_IN_XF_IMPORT_FILE
	/// AW 08/30/06 SUPPORT_MULTI_FILES_INXF
	virtual bool AddFile(LPCSTR strFullFileName, bool bSameFilter ) 
	{
		if ( bSameFilter || 0 == saFileName.GetSize())
		{
			saFileName.Add(strFullFileName);
			return true;
		} 
		return false;  
	} 
	virtual void InitFileArray() 
	{
		saFileName.SetSize(0);
	}

protected:
	StringArray saFileName;
	/// ENDULTI_FILES_INXF
	
};